/*
 * Decompiled with CFR 0.152.
 */
package net.spellcraftgaming.rpghud.gui.hud;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.AbstractGui;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.spellcraftgaming.rpghud.gui.hud.element.HudElement;
import net.spellcraftgaming.rpghud.gui.hud.element.HudElementType;

@OnlyIn(value=Dist.CLIENT)
public abstract class Hud {
    private final String hudKey;
    private final String hudName;
    protected Map<HudElementType, HudElement> elements = new HashMap<HudElementType, HudElement>();
    protected Minecraft mc;
    public int chatOffset = 0;

    public Hud(Minecraft mc, String hudKey, String hudName) {
        this.mc = mc;
        this.hudKey = hudKey;
        this.hudName = hudName;
        this.setElements();
    }

    public void setElements() {
        this.elements.put(HudElementType.HOTBAR, this.setElementHotbar());
        this.elements.put(HudElementType.HEALTH, this.setElementHealth());
        this.elements.put(HudElementType.ARMOR, this.setElementArmor());
        this.elements.put(HudElementType.FOOD, this.setElementFood());
        this.elements.put(HudElementType.HEALTH_MOUNT, this.setElementHealthMount());
        this.elements.put(HudElementType.AIR, this.setElementAir());
        this.elements.put(HudElementType.JUMP_BAR, this.setElementJumpBar());
        this.elements.put(HudElementType.EXPERIENCE, this.setElementExperience());
        this.elements.put(HudElementType.LEVEL, this.setElementLevel());
        this.elements.put(HudElementType.CLOCK, this.setElementClock());
        this.elements.put(HudElementType.DETAILS, this.setElementDetails());
        this.elements.put(HudElementType.WIDGET, this.setElementWidget());
        this.elements.put(HudElementType.COMPASS, this.setElementCompass());
        this.elements.put(HudElementType.ENTITY_INSPECT, this.setElementEntityInspect());
        this.elements.put(HudElementType.STATUS_EFFECTS, this.setElementStatusEffects());
    }

    public String getHudKey() {
        return this.hudKey;
    }

    public String getHudName() {
        return this.hudName;
    }

    protected abstract HudElement setElementHotbar();

    protected abstract HudElement setElementHealth();

    protected abstract HudElement setElementFood();

    protected abstract HudElement setElementArmor();

    protected abstract HudElement setElementAir();

    protected abstract HudElement setElementExperience();

    protected abstract HudElement setElementLevel();

    protected abstract HudElement setElementJumpBar();

    protected abstract HudElement setElementHealthMount();

    protected abstract HudElement setElementClock();

    protected abstract HudElement setElementDetails();

    protected abstract HudElement setElementWidget();

    protected abstract HudElement setElementCompass();

    protected abstract HudElement setElementEntityInspect();

    protected abstract HudElement setElementStatusEffects();

    public void drawElement(HudElementType type, AbstractGui gui, float zLevel, float partialTicks, int scaledWidth, int scaledHeight) {
        this.elements.get((Object)type).draw(gui, zLevel, partialTicks, scaledWidth, scaledHeight);
    }

    public boolean checkElementConditions(HudElementType type) {
        return this.elements.get((Object)type).checkConditions();
    }

    public boolean isVanillaElement(HudElementType type) {
        return this.elements.get((Object)type) == null;
    }
}

